<?php
function getDiskInfo($getterDiskInfo)
{
   if (empty($getterDiskInfo)) {
      return [];
   }
   $hdds = isset($getterDiskInfo->DiskInfo) ? $getterDiskInfo->DiskInfo : [];
   return $hdds;
}
function getStorageInfo()
{
   $sock = Login();
   checkActionAccess($sock, "read");

   try {
      $arr = ParamGet($sock, "DiskInfo");
      if (empty($arr)) {
         return [];
      }
      $dropped_frames = $arr->dropped_frames;
      $limitbufsize = $arr->limitbufsize;
      $maxbufsize = $arr->maxbufsize;
      $curbufsize = $arr->curbufsize;

      $json = [];
      $json["dropped_frames"] = $dropped_frames;
      $json["limitbufsize"] = $limitbufsize;
      // $json['maxbufsize'] = $maxbufsize;
      $json["curbufsize"] = $curbufsize;
      socket_close($sock);
      return $json;
   } catch (Exception $e) {
      socket_close($sock);
      return [];
   }
}
function getLongStorage()
{
   $sock = Login();
   checkActionAccess($sock, "read");
   $arr = ParamGet($sock, "server");
   if (isset($arr->server->longTermCamMask)) {
      $disk["longTermCamMask"] = $arr->server->longTermCamMask;
      $disk["longTermCamMask"] = sort_nested_arrays($disk["longTermCamMask"], ["index" => "desc"]);
   } else {
      $disk["longTermCamMask"] = [];
   }
   $disk["longTermHDNum"] = isset($arr->server->longTermHDNum) ? $arr->server->longTermHDNum : 0;
   socket_close($sock);
   return $disk;
}
